//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help

//window can be brought up whenever? No, permanent fixture

//bar and beat counters

//eventually time signature control plus generative time signature sequences using live coding objects like Pseq of time signatures

//run multiple LiveCoding objects to have multiple time signatures, tempi at once
//but of course can also run without paying attention to master tracks

LCTempoControl {	
	classvar <>oscout;
	var <tempoclock; 
	var w, tempotext, numview, jump, jumpval, accel, accval, interpbeats;
	var tempotarget;
	var <bar, <>barstart, <>nextbar; 
	var bartext, beattext; 
	
	var <tempobus, <bussynth;
	
	var taplist, lasttap, tapbutt,tapbutt2, alignbutt, alignmenu,alignalgos, alignmenuval;
	var roundbutt, roundval; 
	
	var jogback, jogforward, jogging, jogslid; 
	var temposlid, tempolock, lockval, currtempo;
	
	*new {
		^super.new.initLCTempoControl.initUI;
	}
	
	initLCTempoControl {
		//tempoclock= TempoClock(2); do this only when commanded by main engine to get starting exactly when needed
		tempotarget=2;
		
		currtempo=2;
		lockval=0;
		
		bar=0;
		barstart= 0.0; nextbar=0.0;
		
		//to avoid deferring access to UI from tempoclock thread
		jumpval=0;
		accval=0;
		
		taplist=List.new;
		
		lasttap=Main.elapsedTime;
		
		alignalgos= [\immediate1,\slow1,\testtempo];
		alignmenuval=0;
		roundval=0;
	}
	
	initUI {
		var backcol, frontcol, row2;
		
		row2=0; //35; //all on one row now
		
		w= SCWindow("LCTempoControl", Rect(10,68,1024,28),border:true); //will be immovable
		w.alpha_(0.9);
		w.view.background = Gradient(Color.blue,Color.blue(0.2),\v);
		
		backcol= Color.blue(0.7,0.7); //Color.new255(135, 250, 106); //Color.green; //Color.new255(135, 106, 250);
		frontcol= Color.white; //Color.black;//Color.new255(150, 40, 70);
		
		tempotext=SCStaticText(w,Rect(0,0,50,20)).string_("2").font_(Font.default).stringColor_(frontcol);
		
		numview= SCNumberBox(w, Rect(50, 0, 50, 25));
		numview.action_({tempotarget=numview.value;});
		
		jump=SCButton(w, Rect(100,0, 45, 25)).font_(Font.default);
		jump.states= [["jump", frontcol, backcol],["ing", backcol, frontcol]]; 
		jump.action_({jumpval=jump.value;});
		
		accel=SCButton(w, Rect(150,0, 45, 25)).font_(Font.default);
		accel.states= [["accel", frontcol, backcol],["erating", backcol, frontcol]]; 
		accel.action_({accval=accel.value;});
		
		interpbeats= DDSlider(w, Rect(200,0, 100, 25), "interpbeats", 1.0, 50.0, \linear, 1.0, 4.0);
		
		SCStaticText(w,Rect(300,0,50,13)).string_("bar").font_(Font.default).stringColor_(frontcol);
		SCStaticText(w,Rect(350,0,50,13)).string_("beat").font_(Font.default).stringColor_(frontcol);
		
		bartext=SCStaticText(w,Rect(300,15,50,13)).string_("1").font_(Font.default).stringColor_(frontcol);
		beattext=SCStaticText(w,Rect(350,15,50,13)).string_("0.0").font_(Font.default).stringColor_(frontcol);
		
		tapbutt=SCButton(w,Rect(405,row2,45,25)).font_(Font.default);
		tapbutt.states= [["tap me", frontcol, backcol]]; 
		tapbutt.keyDownAction_({
		arg ...args; 
		var tapnow,ioi;
		
		//args.postln;
		
		tapnow=Main.elapsedTime;
		ioi=tapnow-lasttap;
		
		if((args[3]==13) &&((taplist.size)>1.5),{
		this.perform(alignalgos[alignmenu.value.asInteger]);
		ioi=4.0; //force a clear of taplist in a moment
		});
		
		
		//about 600bpm to 40bpm range allowed 
		if((ioi<1.5) && (ioi>0.1), {
				taplist.add([ioi,lasttap,tapnow]);
				tapbutt.states=[[(taplist.size+1).asString, frontcol, backcol]];
				tapbutt.refresh; 
				},
			{
			
			if(ioi>1.4, {
			taplist.clear;
			});
			
			});
			
		lasttap=tapnow;
		
		});
		
		// register MIDIIn functions	
		//MIDIIn.noteOn = { arg src, chan, num, vel; this.miditapfunc(src,chan,num,vel); };
		
		//alignbutt=SCButton(w, Rect(450,0, 45, 40));
		//alignbutt.states= [["align", frontcol, backcol]]; 
		//
		//alignbutt.action_({
		//this.schedAlign;
		//});
		
		tapbutt2=SCButton(w,Rect(455,0,45,25)).font_(Font.default);
		tapbutt2.states= [["1 now", frontcol, backcol]]; 
		tapbutt2.keyDownAction_({
		arg ...args;
		var beatnow,str;
		
		if((args[3]==32),{
		
		beatnow=((tempoclock.elapsedBeats)%4.0);
		str= if(beatnow>2.0,{"+"++((4.0-beatnow).asStringPrec(3))},{"-"++(beatnow.asStringPrec(3))});
		tapbutt2.states=[[str, frontcol, backcol]];
		tapbutt2.refresh;
		//str.postln;
		});
		
		});
		
		
		
		alignmenu= SCPopUpMenu(w, Rect(500,row2, 95, 25)).font_(Font.default).stringColor_(frontcol);
		alignmenu.items= alignalgos;
		alignmenu.action_({alignmenuval= alignmenu.value.asInteger;});
		
		
		roundbutt=SCButton(w, Rect(600,row2, 45, 25)).font_(Font.default);
		roundbutt.states= [["rd on", frontcol, backcol],["rd off", backcol, frontcol]]; 
		roundbutt.action_({roundval=roundbutt.value;});
		
		
		jogging=false;
		
		jogback=SCButton(w, Rect(650,row2, 25, 25)).font_(Font.default);
		jogback.states= [["+", frontcol, backcol]]; 
		jogback.action_({this.jog(-1,jogslid.value);});
		
		jogforward=SCButton(w, Rect(680,row2, 25, 25)).font_(Font.default);
		jogforward.states= [["-", frontcol, backcol]]; 
		jogforward.action_({this.jog(1,jogslid.value);});
		
		jogslid= DDSlider(w, Rect(710,row2, 100, 25), "jog by", 0.0, 2.0, \linear, 0.01, 0.25);
		
		tempolock=SCButton(w, Rect(815,row2, 25, 25)).font_(Font.default);
		tempolock.states= [[" ", frontcol, backcol],["x", backcol, frontcol]]; 
		tempolock.action_({lockval=tempolock.value;});
	
		temposlid= DDSlider(w, Rect(850,row2, 100, 25), "finetune", -0.25,0.25,\linear, 0.001, 0.0);
		temposlid.action_({
			if(lockval>0.5,{this.settempofinetune(temposlid.value)});
			});
		
		//w.userCanClose_(false);
		//w.view.background_(Color.new255(13, 106, 250));
		//w.view.background_(Color.white);
		
		w.front;
		
	}
	
	//
	//miditapfunc
	//{
	//arg src, chan, num, vel;
	//var tapnow,ioi;
	//
	//"hit!".postln;
	//num.postln;
	//
	//tapnow=Main.elapsedTime;
	//ioi=tapnow-lasttap;
	//
	//if((num==42) &&((taplist.size)>1.5),{
	//this.perform(alignalgos[alignmenuval]);
	//
	//Post << taplist <<nl;
	//ioi=4.0; //force a clear of taplist in a moment
	//});
	//
	//
	////about 600bpm to 40bpm range allowed 
	//if((ioi<1.5) && (ioi>0.1),
	//{
	//taplist.add([ioi,lasttap,tapnow]);
	//
	//{tapbutt.states=[[(taplist.size+1).asString]];
	//tapbutt.refresh; 
	//}.defer;
	//},
	//{
	//if(ioi>1.4,
	//{
	//taplist.clear;
	//});
	//
	//});
	//
	//lasttap=tapnow;
	//
	//
	//}
	
	
	//assumes 4/4 for max phase adjustment? Could make more
	//no fine calculations, just apply
	jog {arg direction, amount;
		var tempo,time,spb, temptempo;
		
		if(not(jogging),	//no jogging while already jogging
		{
		jogging=true;
		
		tempo= tempoclock.tempo;
		spb=tempo.reciprocal;
		
		time= (4.0 +(direction*amount))*spb;
		
		temptempo=4.0/time;
		
		//correction tempo
		this.settempo(temptempo);
		
		//restore original tempo 
		SystemClock.sched(time,{
		this.settempo(tempo);
		jogging=false;
		});
		
		});
	
	}
	
	
	//set up interp scheduling or just jump
	update
	{
	var num, mult, pg, start, task;
	
	bar=bar+1;
	//would make timesig decisions here
	barstart= nextbar;
	nextbar= barstart+4.0;
	
	{bartext.string_(bar)}.defer;
	
	//{beattext.string_(barstart)}.defer;
	
	//Routine not Task
	task=Routine({(nextbar-barstart).asInteger.do({arg i;
	
	{beattext.string_(i+1)}.defer;
	1.0.wait;
	})}); //.play(tempoclock, quant:0.0);
	//tempoclock.sched(0.0,{1.0})
	
	//schedule in logical time
	task=tempoclock.sched(0,task);
	
	//how to guarantee that tempo was changed before start of bar when bbcutters are setting envelopes?
	if(jumpval==1,
	{
	jumpval=0;
	
	this.settempo(tempotarget);
	
	{jump.value_(0);}.defer;
	
	});
	
	if(accval==1,
	{
	accval=0;
	{accel.value_(0);}.defer;
	
	num= interpbeats.value.round(1.0).asInteger;
	
	//have num steps to get to tempotarget using geometric progression
	start= tempoclock.tempo;
	
	pg=Pgeom(start, (tempotarget/start)**(1.0/num), num+1).asStream;
	
	tempoclock.schedAbs(tempoclock.elapsedBeats,{
	var next;
	
	next= pg.next;
	
	if(next.notNil,{
	this.settempo(next);
	 1.0},{nil});
	
	});
	});
	
	}
	
	settempo {
	arg tempo;
	
	currtempo=tempo;
	
	tempoclock.tempo_(tempo);
	
	if(oscout.notNil, {oscout.tempo(tempo)});
	bussynth.set(\tempo,tempo);
	
	{tempotext.string_(tempo)}.defer;
	}
	
	
	settempofinetune
	{
	arg tempoadjust;
	var tempo;
	
	tempo=currtempo+tempoadjust;
	
	tempoclock.tempo_(tempo);
	
	if(oscout.notNil, {oscout.tempo(tempo)});
	bussynth.set(\tempo,tempo);
	
	{tempotext.string_(tempo)}.defer;
	}
	
	
	
	run
	{
	arg starttempo=2;
	
	tempobus= Bus.control(Server.default, 1);
	
	Post << [tempobus.index]<<nl; 
	
	//control bus 0 is reserved for the tempocontrol, could reserve 1 and 2 as MouseX and MouseY too? 
	bussynth= SynthDef(\tempobus,{arg tempo=2;
	
	Out.kr(tempobus.index,tempo)}).play(Server.default);
	
	tempoclock= TempoClock(2);
	//tempoclock.tempo_(2);
	
	//tempoclock.tempo.postln;
	
	//tempoclock.schedAbs(tempoclock.elapsedBeats+0.5,{bussynth.set(\tempo,tempoclock.tempo); 0.1});
	}
	
	stop
	{
	lockval=0.0;
	
	tempoclock.stop;
	
	tempobus.free;
	
	SystemClock.sched(0.3,{bussynth.free; nil});
	
	w.close;
	}
	
	testtempo
	{
	var tempi, lsq;
	
	Post << taplist<<nl;
	
	tempi=taplist.collect({arg v; (v[0]).reciprocal});
	
	lsq= this.tempophaseleastsq;
	
	Post <<[tempi, (tempi.sum)/(tempi.size), ((tempi.squared.sum)/(tempi.size)).sqrt, lsq[0].reciprocal] <<nl;
	}
	
	
	tempophaseleastsq {
		var tempi;
		var x,y,n, xsum, ysum, xxsum, xysum, grad, intercept;
		
		tempi=taplist.collect({arg v; (v[0]).reciprocal});
		
		//least squares fit of tempi data (beat num, observed time), gradient of line gives
		//best fit tempo
		n=taplist.size;
		x=Array.series(n,0,1);
		y=taplist.collect({arg v; v[1]});
		 
		xsum= x.sum;
		ysum=y.sum;
		xxsum=x.squared.sum;
		xysum=(x*y).sum;
		
		grad= ((xsum*ysum)-(xysum*n))/((xsum*xsum)-(n*xxsum));
		
		//y=bx+a, knock out intercept, only grad important, b.1= y= time in one beat
		//Post << [grad,grad.reciprocal,(tempi.sum)/n] <<nl; 
		
		//phaseerrors
		//y=grad.x+intercept  (y-intercept)/grad=x
		
		//determining intercept gives the phase lock- minimise sigma (grad*x+intercept-observed time).squared
		
		intercept= (y.collect({arg v,j; v-(grad*(j+1))}).sum)/n;
		
		//y=bx+a, knock out intercept, only grad important, b.1= y= time in one beat
		//Post << [grad,grad.reciprocal,(tempi.sum)/n] <<nl; 
		//Post <<["phase- time of beat 1 ", grad+intercept, y[0]]<<nl;
		
		^[grad,intercept];
	}
	
	
	//one segment of time at catchup tempo- from then at target tempo
	//no attempt to remain perceptually adequate
	immediate1{
		var temponow,tempotarget, beatnow; 
		var now, alignfirsttap, ago;
		var phaseerror;
		var clockbeat, alignbeat;
		var temp;
		var grad, intercept;
		var 	correctiontime, correctiontempo;
		
		#grad,intercept= this.tempophaseleastsq;
		
		now=Main.elapsedTime;
		//schedule alignment
		
		//timepos of first tap error corrected, assumed location of first beat of bar
		alignfirsttap= grad+intercept;
		
		temponow=tempoclock.tempo;
		tempotarget=grad.reciprocal;
		
		//round bpm to nearest 0.25- allows for inaccuracy in tap collection 
		//and assumes original was recorded at a metronome tempo or thereabouts
		if(roundval<0.5,{tempotarget= (((tempotarget*60).round(0.5))/60); });
		
		ago= now-alignfirsttap;
		
		//need current clocks beatpos at alignfirsttap- assume constant tempo and project back 
		
		beatnow=tempoclock.elapsedBeats;
		
		clockbeat=beatnow%4.0; 
		
		//this gives beat then, but don't need that //(beatnow-((tempoclock.tempo)*ago))%4.0;
		alignbeat=(ago*tempotarget)%4.0;
		
		Post << ["alignment", clockbeat, alignbeat, beatnow, ago]<<nl;
		
		//eqns 
		//(tempotarget*correctiontime)= (4.0-alignbeat)+4.0
		//(correctiontempo*correctiontime)= (4.0-clockbeat)+4.0
		
		//never zero since alignbeat always <=4.0
		correctiontime=(8.0-(alignbeat))/tempotarget;
		
		correctiontempo=(8.0-(clockbeat))/correctiontime;
		
		
		//if(alignbeat.equalWithPrecision(clockbeat,0.0001),
	//	{tempotarget},
	//	{
	//	});
	//	
		Post << ["correction", correctiontime, correctiontempo]<<nl;
		
		
		this.settempo(correctiontempo);
		SystemClock.sched(correctiontime,{
		tempoclock.elapsedBeats.postln;
		Post <<[now,Main.elapsedTime,correctiontime]<<nl;
		
		this.settempo(tempotarget);
		});
	
	}
	
	
	//work out a slow path to the desired state
	slow1
	{
	var temponow,tempotarget, beatnow, beattarget, diff; 
	var segments, timetoalign, seglen, segtempi;
	var now, alignfirsttap, ago;
	var phaseerror, pseq;
	var clockbeat, alignbeat, currphaseerror;
	var temp;
	var grad, intercept;
	
	#grad,intercept= this.tempophaseleastsq;
	
	now=Main.elapsedTime;
	//schedule alignment
	
	//timepos of first tap error corrected, assumed location of first beat of bar
	alignfirsttap= grad+intercept;
	
	temponow=tempoclock.tempo;
	tempotarget=grad.reciprocal;
	
	if(roundval<0.5,{tempotarget= (((tempotarget*60).round(0.25))/60)});
		
	ago= now-alignfirsttap;
	
	//need current clocks beatpos at alignfirsttap- assume constant tempo and project back 
	
	beatnow=tempoclock.elapsedBeats;
	
	clockbeat=(beatnow-((tempoclock.tempo)*ago))%4.0;
	alignbeat=(ago*tempotarget)%4.0;
	
	diff= (clockbeat-alignbeat).abs;
	
	//could do min and take to range -1 to 1 but hey
	currphaseerror=(diff).min(4.0-diff); 
	
	Post <<["errors ", beatnow, clockbeat, alignbeat, diff, currphaseerror]<<nl;
	
	//how many segments?
	segments=50;	//must be even
	timetoalign=10;
	seglen=timetoalign/segments;
	
	beattarget= beatnow+currphaseerror+(timetoalign*tempotarget);
	
	//first approximation is an interpolation
	segtempi= Array.fill(segments,{arg i;  var t;  t= i/(segments); (temponow*(1-t)) + (tempotarget*t)});
	
	//now error correct
	phaseerror= beattarget- ((segtempi.collect({arg t;  t*seglen}).sum)+beatnow);
	
	//share among segments with more share in the middle
	//phaseerror= phaseerror/(segments);
	
	//could choose geom multiplier param so that maintain JND of tempo perception?
	temp= 100**(1/(segments.div(2))); //so middle is 20 times more error corrected than outer
	
	temp=Array.geom(segments.div(2),1,temp);
	
	temp=(temp++(temp.reverse)).normalizeSum;
	
	phaseerror= temp*phaseerror;
	
	segments.do({arg i;  var segt, beatlen, correct;   
	
	segt= segtempi[i]; 
	beatlen= seglen*segt;
	correct= (beatlen+(phaseerror[i]))/seglen;
	
	Post << [beatlen, phaseerror[i], seglen, correct] <<nl; 
	
	segtempi[i]=correct;
	});
	
	Post <<[temponow, tempotarget, segtempi,phaseerror, beattarget]<<nl;
	
	//now schedule
	pseq= Pseq(segtempi++[tempotarget],1).asStream;
	
	SystemClock.sched(0.0,{
	var newtempo;
	
	newtempo=pseq.next;
	
	if(newtempo.notNil,{
	this.settempo(newtempo);
	
	newtempo.postln;
	
	seglen
	},{nil});
	});
	
	}
	
}